/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedDividedPanelBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean vertical;

    public FramedDividedPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedDividedPanel.get(), pos, state);
        this.vertical = state.m_60734_() == FBContent.blockFramedDividedPanelVert.get();
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        Direction face = hit.m_82434_();
        if (this.vertical) {
            Direction dir = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
            if (face == dir.m_122427_()) {
                return true;
            }
            if (face == dir.m_122428_()) {
                return false;
            }
            double xz = Utils.fractionInDir(hit.m_82450_(), dir.m_122427_());
            return xz > 0.5;
        }
        return switch (face) {
            case Direction.UP -> true;
            case Direction.DOWN -> false;
            default -> {
                Vec3 frac = Utils.fraction(hit.m_82450_());
                if (frac.f_82480_ > 0.5) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        return this.vertical ? DoubleSoundMode.EITHER : DoubleSoundMode.SECOND;
    }

    @Override
    public BlockState getCamoState(Direction side) {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean isSolidSide(Direction side) {
        if (side == this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR)) {
            return this.getCamoState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_) && this.getCamoStateTwo().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return false;
    }
}

